/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.musiccontroller;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.element.elements.musiccontroller.MusicControllerElement;
import de.keksuccino.fancymenu.events.ticking.ClientTickEvent;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinMusicManager;
import de.keksuccino.fancymenu.util.WorldUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MusicControllerHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, ActiveController> CONTROLLERS = new HashMap<String, ActiveController>();
    private static boolean initialized = false;
    private static boolean playMenuMusic = true;
    private static boolean playWorldMusic = true;
    private static boolean worldMusicManuallyStopped = false;
    private static boolean menuMusicManuallyStopped = false;
    private static boolean lastTickScreenOpen = false;

    public static void init() {
        if (!initialized) {
            initialized = true;
            EventHandler.INSTANCE.registerListenersOf(new MusicControllerHandler());
        }
    }

    @EventListener
    public void onClientTickPost(ClientTickEvent.Post e) {
        boolean screenOpen = class_310.method_1551().field_1755 != null;
        ArrayList<ActiveController> cachedControllers = new ArrayList<ActiveController>(CONTROLLERS.values());
        cachedControllers.forEach(activeController -> {
            if (!activeController.updated) {
                CONTROLLERS.remove(activeController.controller.getInstanceIdentifier());
            }
            activeController.updated = false;
        });
        playMenuMusic = true;
        playWorldMusic = true;
        if (!CONTROLLERS.isEmpty() && screenOpen) {
            CONTROLLERS.values().forEach(activeController -> {
                if (!activeController.controller.playMenuMusic) {
                    playMenuMusic = false;
                }
                if (!activeController.controller.playWorldMusic) {
                    playWorldMusic = false;
                }
            });
            if (!MusicControllerHandler.isWorldLoaded()) {
                if (FancyMenu.getOptions().playVanillaMenuMusic.getValue().booleanValue()) {
                    if (!playMenuMusic && MusicControllerHandler.isMenuMusicPlaying()) {
                        class_310.method_1551().method_1538().method_4859();
                        class_310.method_1551().method_1483().method_4881();
                        menuMusicManuallyStopped = true;
                    } else if (playMenuMusic && !MusicControllerHandler.isMenuMusicPlaying()) {
                        class_310.method_1551().method_1538().method_4858(class_310.method_1551().method_1544());
                        menuMusicManuallyStopped = false;
                    }
                }
            } else if (!playWorldMusic && !worldMusicManuallyStopped) {
                class_310.method_1551().method_1483().method_71939(new class_3419[0]);
                worldMusicManuallyStopped = true;
            } else if (playWorldMusic && worldMusicManuallyStopped) {
                class_310.method_1551().method_1483().method_4880();
                worldMusicManuallyStopped = false;
            }
        }
        if (!screenOpen) {
            if (MusicControllerHandler.isWorldLoaded() && lastTickScreenOpen && worldMusicManuallyStopped) {
                class_310.method_1551().method_1483().method_4880();
            }
            worldMusicManuallyStopped = false;
        }
        if (CONTROLLERS.isEmpty()) {
            if (menuMusicManuallyStopped) {
                if (!MusicControllerHandler.isMenuMusicPlaying()) {
                    class_310.method_1551().method_1538().method_4858(class_310.method_1551().method_1544());
                }
                menuMusicManuallyStopped = false;
            }
            if (MusicControllerHandler.isWorldLoaded() && worldMusicManuallyStopped) {
                if (class_310.method_1551().field_1755 != null && !class_310.method_1551().field_1755.method_25421() || WorldUtils.isMultiplayer()) {
                    class_310.method_1551().method_1483().method_4880();
                }
                worldMusicManuallyStopped = false;
            }
        }
        lastTickScreenOpen = screenOpen;
    }

    public static void notify(@NotNull MusicControllerElement controller) {
        ActiveController activeController = CONTROLLERS.computeIfAbsent(controller.getInstanceIdentifier(), k -> new ActiveController(controller));
        activeController.updated = true;
    }

    public static boolean shouldPlayMenuMusic() {
        return playMenuMusic;
    }

    public static boolean shouldPlayWorldMusic() {
        return playWorldMusic;
    }

    private static boolean isMenuMusicPlaying() {
        return ((IMixinMusicManager)class_310.method_1551().method_1538()).getCurrentMusic_FancyMenu() != null;
    }

    private static boolean isWorldLoaded() {
        return class_310.method_1551().field_1687 != null;
    }

    protected static class ActiveController {
        protected MusicControllerElement controller;
        protected boolean updated = false;

        protected ActiveController(@NotNull MusicControllerElement controller) {
            this.controller = controller;
        }
    }
}

